#ifndef __CStepLabel__
#define __CStepLabel__

#include "CTextLabel.hpp"
#include <Collections/CollectionTypedef.h>
#include "../Listeners/IActionListener.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CTextLabel;
using Exponent::GUI::Listeners::IActionListener;
using Exponent::Collections::TStringCountedPointerArray;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CStepLabel CStepLabel.hpp
			 * @brief Displays text in a box area, that can be incremented / decremented through a list
			 *
			 * @date 17/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CStepLabel.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			class CStepLabel : public CTextLabel, public IActionListener
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * @enum EStepLabelButtons
				 * @brief Enumerator of the buttons that can control this control
				 */
				enum EStepLabelButtons
				{
					e_stepIncrementButton = 0,		/**< Increment */
					e_stepDecrementButton,			/**< Decrement */
				};

//	===========================================================================

				
				/**
				 * Construction 
				 * @param root The root control
				 * @param uniqueId The uniqueId
				 * @param area The area of the control
				 * @param listener The action listener
				 */
				CStepLabel(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CStepLabel();

//	===========================================================================

				/**
				 * Add a string
				 * @param string The string to add
				 */
				void addString(const CString &string);

				/**
				 * Get the string array
				 * @retval TStringCountedPointerArray* The string array
				 */
				const TStringCountedPointerArray *getStringArray() const { return m_stringArray; }

				/**
				 * Get the string Array
				 * @retval TStringCountedPointerArray* The string array
				 */
				TStringCountedPointerArray *getMutableStringArray() const { return m_stringArray; }

				/**
				 * Should the string table be wrapped at the ends (ie is the step after arraySize zero?)
				 */
				void wrapStringsAtEdges(const bool wrap) { m_wrapStrings = wrap; }

//	===========================================================================

				/**
				 * Move to the next string
				 */
				void nextString();

				/**
				 * Move to the previous string
				 */
				void previousString();

				/**
				 * Set the index
				 * @param step The step you want to display
				 */
				void setStep(const long step);

//	===========================================================================
				
				/**
				 * Handle an event - a control has changed in some way and wants you\n
				 * to update the internal workings accordingly
				 * @param event The event to hande
				 * @note Expects control id to be from EStepLabelButtons
				 */
				virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

			protected:

//	===========================================================================

				TStringCountedPointerArray *m_stringArray;		/**< The array of strings to display */
				bool m_wrapStrings;								/**< Wrap strings? */
				long m_currentStringIndex;						/**< Current selection */

			};
		}
	}
}
#endif	// End of CStepLabel.hpp